const scriptURL = 'https://script.google.com/macros/s/AKfycbyqOWhY_p4TCTHEi1ITG-03qCGuwV5XidmM-75jM1G7vdgSVOD_AMkXm50nHXqbz5ctNA/exec';

const form = document.forms['submit-to-google-sheet'];

form.addEventListener('submit', async (e) => {
  e.preventDefault();

  try {
    const formData = new FormData(form);
    const response = await fetch(scriptURL, {
      method: 'POST',
      body: formData
    });

    if (!response.ok) {
      throw new Error(`Network response was not ok: ${response.statusText}`);
    }

    const responseData = await response.json();  // 这里能正常解析了
    console.log('Form submission successful:', responseData);
    alert('Form submitted successfully!');
    form.reset();
  } catch (error) {
    console.error('Error submitting form:', error);
    alert('Error submitting form. Please try again later.');
  }
});